
TYPE
	PMCConstantsType : 	STRUCT  (*Constants for the PMC system*)
		H2P_FRMC_OFFSET : UINT := 4;
		H2P_CMDC_OFFSET : UINT := 5;
		H2P_CMDID_OFFSET : UINT := 6;
		H2P_CMDLB_OFFSET : UINT := 8;
		H2P_DATA_OFFSET : UINT := 10;
		H2P_DATA_END_OFFSET : UINT := 103;
		H2P_EVENTACK_OFFSET : UINT := 129;
		H2P_EVENTID_OFFSET : UINT := 130;
		H2P_STM_OFFSET : UINT := 132;
		H2P_DO_OFFSET : UINT := 384;
		
		P2H_FRMC_OFFSET : UINT := 4;
		P2H_CMDC_OFFSET : UINT := 5;
		P2H_CMDID_OFFSET : UINT := 6;
		P2H_CMDLB_OFFSET : UINT := 8;
		P2H_RTN_OFFSET : UINT := 10;
		P2H_DATA_OFFSET : UINT := 12;
		P2H_PMC_STATE_OFFSET : UINT := 54;
		P2H_REGION_STATE_OFFSET : UINT := 55;
		P2H_TIMESTAMP_OFFSET : UINT := 72;
		P2H_FB_FRAME_NUM_OFFSET : UINT := 80;
		P2H_NUM_ACCIDENT_OFFSET : UINT := 81;
		P2H_NUM_INCOMING_OFFSET : UINT := 82;
		P2H_EVENT_OFFSET : UINT := 83;
		P2H_XBOT_STATE_OFFSET : UINT := 89;
		P2H_MUX_OFFSET : UINT := 128;
		P2H_REAL_TIME_OFFSET : UINT := 188;
		P2H_XBOT_STATE_FRAME_NUM_OFFSET : UINT := 380;
		P2H_FRMC_OFFSET2 : UINT := 383;
		P2H_DI_OFFSET : UINT := 384;
		P2H_PROTOCOL_OFFSET : UINT := 0;
		
		PMC_TIMEOUT : UINT := 7500;
		TICKET_TIMEOUT : UINT := 10;
		
		PMCDB_MAXXBOTS : UINT := 127;
	END_STRUCT;
	PMCDBType : 	STRUCT  (*Stores PMC state and positions of all the xbots*)
		XbotStateFieldbusRaw : ARRAY[0..199]OF USINT;
		StereoID : ARRAY[0..126]OF USINT;
		XbotStatus : ARRAY[0..126]OF USINT;
		XIDScan : ARRAY[0..126]OF BOOL;
		PosX : ARRAY[0..126]OF REAL;
		PosY : ARRAY[0..126]OF REAL;
		PosZ : ARRAY[0..126]OF REAL;
		PosRx : ARRAY[0..126]OF REAL;
		PosRy : ARRAY[0..126]OF REAL;
		PosRz : ARRAY[0..126]OF REAL;
		FeedbackX : ARRAY[0..126]OF REAL;
		FeedbackY : ARRAY[0..126]OF REAL;
		FeedbackZ : ARRAY[0..126]OF REAL;
		FeedbackRx : ARRAY[0..126]OF REAL;
		FeedbackRy : ARRAY[0..126]OF REAL;
		FeedbackRz : ARRAY[0..126]OF REAL;
		FeedbackXID : ARRAY[0..126]OF USINT;
		ForceX : ARRAY[0..126]OF REAL;
		ForceY : ARRAY[0..126]OF REAL;
		ForceZ : ARRAY[0..126]OF REAL;
		ForceRx : ARRAY[0..126]OF REAL;
		ForceRy : ARRAY[0..126]OF REAL;
		ForceRz : ARRAY[0..126]OF REAL;
	END_STRUCT;
	PMCFuncInfoType : 	STRUCT  (*Stores the status of a single function block instance*)
		CmdSta : USINT;
		TicketNumber : USINT;
		EventID : UINT;
		SendToPMC : BOOL;
		ReadFromPMC : BOOL;
		MsgPartNStatus : DINT;
		LastMsgPartNStatus : DINT;
	END_STRUCT;
	PMControllerType : 	STRUCT  (*Tracks state of the entire PMC system*)
		DataFromPMC : ARRAY[0..199]OF UINT;
		DataToPMC : ARRAY[0..199]OF UINT;
		ConfiguredFeedbackStreamAxis : SINT;
		PMCDB : PMCDBType;
		TicketMgmt : PMCTicketType;
		EventMgmt : PMCEventType;
		PMC_Constants : PMCConstantsType;
		PrevEventID1 : UINT;
		PrevEventCode1 : SINT;
		PrevEventID2 : UINT;
		PrevEventCode2 : SINT;
		PrevFrmCountFromPMC : USINT;
		NumMissedFrames : UINT;
	END_STRUCT;
	PMCTicketType : 	STRUCT  (*Used to determine which function block has access to the fieldbus*)
		AvailableTicket : USINT;
		ExecutingTicket : USINT;
		TicketStatus : ARRAY[0..255]OF BOOL;
		TicketExpired : ARRAY[0..255]OF BOOL;
		TicketTimeout : UINT;
	END_STRUCT;
	PMCEventType : 	STRUCT  (*Tracks event IDs and event codes*)
		AvailableEventID : UINT;
		ExecutingEventID : ARRAY[0..5000]OF BOOL;
		EventCode : ARRAY[0..5000]OF USINT;
	END_STRUCT;
END_TYPE
